//
//  AppKit-Future.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.07.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#if NSFoundationVersionNumber < 1545

@interface NSApplication (Future)

- (void)loadCompatibility;

@end

#ifndef NSLineCapStyleButt
#define NSLineCapStyleButt NSButtLineCapStyle
#endif

#ifndef NSControlSizeLarge
#define NSControlSizeLarge 3
#endif

#ifndef NSTitlebarSeparatorStyleLine
#define NSTitlebarSeparatorStyleLine 1
#endif

#ifndef MAC_OS_X_VERSION_10_16
typedef NSInteger NSWindowToolbarStyle;
@interface NSWindow (Future)
@property NSWindowToolbarStyle toolbarStyle;
@property (strong) NSString *subtitle;
@property (assign) int titlebarSeparatorStyle;
@end
#define NSWindowToolbarStyleUnifiedCompact 4
#define NSWindowToolbarStyleExpanded 1

@interface NSTableView (Future)
- (void)setStyle:(NSInteger)style;
@end
#define NSTableViewStyleFullWidth 1
#define NSTableViewStyleInset 2
#define NSTableViewStylePlain 4

@interface NSToolbarItem (Future)
@property(getter=isNavigational) BOOL navigational;
@end
#endif
#endif
